# S12000 {#S12000}

## Error Code {#error_code .section}

S12000

## Error Message {#error_message .section}

`Failed to rename the checkpoint file. Refer to the errno for details. RefId: S12000`

## Probable Causes {#probable_causes .section}

This error occurs when the system fails to rename the temporary file *checkpoint.tmp* to *checkpoint.meta*. This may be due to an invalid file path or the *checkpoint.tmp* file being deleted.

## Solutions {#solutions .section}

Troubleshoot based on the specific errno. Common issues include:

-   EACCES: Lack of write permissions for the old or new file path. To solve this issue, ensure that the user has write permissions for the checkpoint file and the *PKEYMetaLog* directory.
-   ENOSPC: Insufficient disk space. To solve this issue, free up disk space in time.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

