# S09008 {#S09008}

## Error Code {#error_code .section}

S09008

## Error Message {#error_message .section}

`JIT: Inferring return type failed. All return values must have the same data type. RefId: S09008JIT: Inferring return type failed. All return values must have the same data type. RefId: S09008`

## Probable Causes {#probable_causes .section}

This error occurs when a JIT function returns results of different data types.

In the following script, the `if` condition returns an INT value while the `else` condition returns a DOUBLE value, which triggers the error:

``` {#codeblock_unc_dzl_jcc}
@jit
def demo(val) {
  if (val > 0) {
    return 1
  } else {
    return 1.0
  }
}
demo(1)
```

## Solutions {#solutions .section}

Ensure that all return values of a JIT function have the same data type.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

