# S09007 {#S09007}

## Error Code {#error_code .section}

S09007

## Error Message {#error_message .section}

`JIT: Right operand of 'cast' must be a constant. RefId: S09007`

## Probable Causes {#probable_causes .section}

The right operand of `cast` \(`$`\) must be a constant indicating the data type, such as INT and LONG.

In the following script, the error occurs because the right operand of `cast`, *type*, is a variable assigned the value LONG:

``` {#codeblock_if5_zyl_jcc}
@jit
def demo() {
  a = 1
  type = LONG
  a$type
}
demo()
```

## Solutions {#solutions .section}

Ensure that the right operand of cast \($\) is a constant.

``` {#codeblock_pw5_1zl_jcc}
@jit
def demo() {
  a = 1
  a$LONG
}
demo()
```

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

