# S07006 {#S07006}

## Error Code {#error_code .section}

S07006

## Error Message {#error_message .section}

`Cannot use aggregate functions to update the IMOLTP table. RefId: S07006`

## Probable Causes {#probable_causes .section}

This error occurs when an aggregate function is used to update a table in an IMOLTP database.

``` {#codeblock_mdk_15j_ncc}
dbName = "oltp://test_imoltp"

if (existsDatabase(dbName)) {
    dropDatabase(dbName)
}

db = database(dbName, VALUE, 1..100, , "IMOLTP")

// pt1 uses column "id" as the primary key and has no secondary key
pt1 = db.createIMOLTPTable(
    table(1:0, ["id", "val1", "val2", "sym"], [LONG, INT, LONG, STRING]),
    "test_table_1",
    primaryKey=`id
)

update pt1 set val1 = max(val2)  // Cannot use aggregate functions to update a table in an IMOLTP database.
```

## Solutions {#solutions .section}

Modify the `update` statement to ensure that it does not contain aggregate functions.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

