# S06011 {#S06011}

## Error Code {#error_code .section}

S06011

## Error Message {#error_message .section}

`Please use '==' rather than '=' as equal operator in non-sql expression. RefId: S06011`

## Probable Causes {#probable_causes .section}

Only in SQL are `=` and `==` equivalent, both representing equal values. In non-SQL context, `=` is used only for assignment.

For example, this error occurs when using `=` to evaluate the expression `1=2`.

``` {#codeblock_xvt_r32_1cc}
1 = 2
```

## Solutions {#solutions .section}

In non-SQL context, ensure that `=` is used only for assignment and replace those misused for equation with `==`.

``` {#codeblock_y1y_s32_1cc}
1 == 2

t = table([1,2,3] as id, [10,,30] as val)
select * from t where id = 2
select * from t where id == 2
```

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

