# S06009 {#S06009}

## Error Code {#error_code .section}

S06009

## Error Message {#error_message .section}

`To form a pair, both operands must have the same data category. RefId: S06009`

## Probable Causes {#probable_causes .section}

Operands of a pair must meet at least one of the following conditions:

-   They are of the same type.

-   They both belong to the INTEGRAL, FLOATING, or DECIMAL categories.


Otherwise, this error occurs, as shown in the following script:

``` {#codeblock_xvt_r32_1cc}
1:"a"  // 1 is of INT type but "a" is of STRING type
2012.06M:2013.06.13  // 2012.06M is of MONTH type but 2013.06.13 is of DATE type
```

## Solutions {#solutions .section}

Ensure that the values of each pair meet the above-mentioned conditions.

``` {#codeblock_y1y_s32_1cc}
1:2    // INT pair
1:2l   // LONG pair
1f:2F  // DOUBLE pair
1:2f   // FLOAT pair
```

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

