# S06008 {#S06008}

## Error Code {#error_code .section}

S06008

## Error Message {#error_message .section}

`The definition of <xxx> is inconsistent with the declared signature. RefId: S06008`

## Probable Causes {#probable_causes .section}

This error occurs when the declared signature is inconsistent with the defined signature.

For example, an error may arise due to an inconsistent number of parameters.

``` {#codeblock_xvt_r32_1cc}
def f(a)  // The declared function f takes a single parameter

def f(a, b) {  // The defined function f takes two parameters, which is inconsistent with the declared function

}
```

Inconsistent parameter names trigger no error, but subsequent function calls must use the parameter name as declared, otherwise, the error [S06004](S06004.dita) occurs.

``` {#codeblock_a3l_w32_1cc}
def f(a)
def f(b) {
}
f(b=1)
```

## Solutions {#solutions .section}

Ensure that the declared signature is consistent with the defined signature.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

