# S06006 {#s06006}

## Error Code {#error_code .section}

S06006

## Error Message {#error_message .section}

`The object 'xxx' is neither an XDB connection nor a function definition. RefId: S06006`

## Probable Causes {#probable_causes .section}

This error is raised when calling an object that is not callable. In DolphinDB, only the following two types of objects are callable:

-   Functions;

-   XDB connection handles \(see [xdb](../../Functions/x/xdb.md)\).


If you attempt to call an object that is not callable, this error will be reported:

``` {#codeblock_aj3_x2t_1bc}
def f(x) { 
    return x() // This will not cause an error, as it is not yet known whether x is a callable object 
} 

f(1) 
// This will cause an error, because the Constant 1 is not a callable object 

f(::now) 
// This will not cause an error, because the built-in function now is a callable object
```

## Solutions {#solutions .section}

As in the example above, if the parameter of `f` requires a callable object, the argument passed in must be modified to a callable object.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

