# S06005 {#s06005}

## Error Code {#error_code .section}

S06005

## Error Message {#error_message .section}

`Not allowed to overwrite existing built-in functions/procedures. RefId: S06005`

## Probable Causes {#probable_causes .section}

If you define a function with the same name as an existing built-in function, this error will be reported. For example, `now` is a built-in function, but the following code attempts to define a function with the same name:

``` {#codeblock_es3_r2t_1bc}
def now() {
    return "I don't know" 
}
```

## Solutions {#solutions .section}

Avoid using a built-in function name when defining a function.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

