# S06003 {#s06003}

## Error Code {#error_code .section}

S06003

## Error Message {#error_message .section}

`Not allowed to define a named function <xxx> within another function. RefId: S06003`

## Probable Causes {#probable_causes .section}

It is not allowed to define a named function within another named function definition. Otherwise, this error will be reported. For example:

``` {#codeblock_ud5_vdt_1bc}
def f1() { 
    def f2() { 
        return "Hello" 
    } 
    return f2() 
}
```

## Solutions {#solutions .section}

-   Change the nested named function to an anonymous function \(recommended\):

    ``` {#codeblock_xrh_xdt_1bc}
    def f1() {
        f2 = def () { // Define an anonymous function
            return "Hello" 
        } 
        return f2() 
        }
    ```

-   Move the nested function to the global scope:

    ``` {#codeblock_xps_xdt_1bc}
    def f2() { 
        return "Hello" 
    } 
    
    def f1() {
        return f2() 
    }
    ```


**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

