# S06001 {#s06001}

## Error Code {#error_code .section}

S06001

## Error Message {#error_message .section}

`If one argument is passed as keyword argument, all subsequent arguments must also be passed as keyword arguments. RefId: S06001`

## Probable Causes {#probable_causes .section}

When calling a function with multiple arguments, if one argument is specified as a keyword argument, all subsequent arguments must also be specified as keyword arguments. Otherwise, this error will be reported. For example:

``` {#codeblock_w3x_ndt_1bc}
def my_func(a, b, c) {
     return a + b + c 
} 
my_func(1, b=2, 3)
```

## Solutions {#solutions .section}

When calling a function with multiple parameters, if one argument is specified as a keyword argument, all subsequent arguments must also be specified as keyword arguments.

The above scripts can be modified to either of the following:

``` {#codeblock_acm_4dt_1bc}
my_func(1, 2, 3)  // no keyword argument
my_func(a=1, b=2, c=3)  // Specify all keyword arguments
my_func(1, b=2, c=3)  // Specify keyword arguments for b and all subsequent arguments
```

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

