# S05013 {#S05013}

## Error Code {#error_code .section}

S05013

## Error Message {#error_message .section}

`All elements of a tuple column of a table must have the same type. RefId: S05013`

## Probable Causes {#probable_causes .section}

When creating an in-memory table, this error occurs if a tuple column of the table contains different types of elements.

For example, an error may arise because the third element is a string, while the first and second elements are both integers.

``` {#codeblock_ftm_2rz_zbc}
t = table(1 2 3 as id, (1, 2, "3") as val)
```

## Solutions {#solutions .section}

When creating an in-memory table, ensure that each tuple column in the table contains elements of the same type.

``` {#codeblock_s4j_1sz_zbc}
t = table(1 2 3 as id, (1, 2, 3) as val)
```

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

