# S05010 {#S05010}

## Error Code {#error_code .section}

S05010

## Error Message {#error_message .section}

`scale out of bounds (valid range: [0, 9], but get: <xxx>). RefId: S05010`

`scale out of bounds (valid range: [0, 18], but get: <xxx>). RefId: S05010`

`scale out of bounds (valid range: [0, 38], but get: <xxx>). RefId: S05010`

## Probable Causes {#probable_causes .section}

Each DECIMAL type has a valid range for its *scale*. This error occurs when the *scale* of a DECIMAL value exceeds the corresponding range.

The valid *scale* range of each DECIMAL type is as follows:

-   `DECIMAL32`: \[0, 9\]

-   `DECIMAL64`: \[0, 18\]

-   `DECIMAL32`: \[0, 38\]


For example, an error may arise because the *scale* of `DECIMAL32` exceeds \[0, 9\] and that of `DECIMAL64` exceeds \[0, 18\].

``` {#codeblock_ftm_2rz_zbc}
v = decimal32(1 2 3 4, 10)

1.23$DECIMAL64(20)
```

## Solutions {#solutions .section}

Set the *scale* of each DECIMAL value to an integer within the corresponding range.

``` {#codeblock_tvb_3rz_zbc}
v = decimal32(1 2 3 4, 6)

1.23$DECIMAL64(10)
```

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

