# S05005 {#s05005}

## Error Code {#error_code .section}

S05005

## Error Message {#error_message .section}

`Not allowed to create a void vector. RefId:S05005`

## Probable Causes {#probable_causes .section}

It is not allowed to create a vector of VOID type. This error commonly occurs in the following situations:

-   Creating a vector of length N where all elements are null.

    ``` {#codeblock_ult_ngt_1bc}
    take(NULL, 5)
    ```

-   Specifying NULL as a column when creating a table.

    ``` {#codeblock_t5b_4gt_1bc}
    t = table(NULL as x, 1..5 as y)
    ```


## Solutions {#solutions .section}

Explicitly specify the type of the null value. For example, the above scripts can be modified as follows:

-   Creating a vector of length N where all elements are NULL.

    ``` {#codeblock_u4v_4gt_1bc}
    take(int(NULL), 5)
    ```

-   Specifying a vector with null values of a certain type when creating a table.

    ``` {#codeblock_dvg_pgt_1bc}
    t = table(take(int(NULL), 5) as x, 1..5 as y)
    ```


**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

