# S05004 {#s05004}

## Error Code {#error_code .section}

S05004

## Error Message {#error_message .section}

`The column <xxx> expects type of <Type1>, but the actual type is <Type2>. RefId:S05004`

## Probable Causes {#probable_causes .section}

This error occurs when attempting to write data of Type2 to a column of Type1 in a DFS table, where Type1 and Type2 are incompatible types.

Type1 and Type2 are considered compatible only if one of the following conditions holds:

-   Type1 and Type2 are the same data type, e.g., both INT.
-   Type1 and Type2 belong to the same category, e.g., INT and LONG are both Integral types.
-   Type1 is a Floating type, and Type2 is an Integral type.
-   Type1 is a DECIMAL type, and Type2 is an Integral or Floating type.

## Solutions {#solutions .section}

Check the data types of the input data and the target table, then

-   Modify the table schema.
-   Or explicitly cast the data types of the input data.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

