# S03020 {#s03020}

## Error Code {#error_code .section}

S03020

## Error Message {#error_message .section}

`The leader has not been elected. Try again later. RefId: S03020`

## Probable Causes {#probable_causes .section}

When using the `getStreamingLeader` function to obtain the leader of HA streaming, this error is raised if the leader is being switched, specifically:

-   The high-availability group has not elected a leader yet.
-   Subscription on the high-availability has not be rebuilt yet.

## Solutions {#solutions .section}

-   Wait for seconds and try again.
-   Implement a loop to repeatedly attempt the `getStreamingLeader` function until it succeeds with `try-catch`.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

