# S03012 {#s03012}

## Error Code {#error_code .section}

S03012

## Error Message {#error_message .section}

`Data insertion failed: Number of columns in the data to insert doesn't match the target table. If you're trying to persist table, a table with the same name may exist on disk. Consider changing the table name, adjusting the data schema, or deleting the existing table from persistentDir and retrying. RefId: S03012`

## Probable Causes {#probable_causes .section}

This error occurs in the following cases:

1.  When appending data to a stream table \(with `append!` or `insert into`\), its schema does not match the table schema.
2.  When calling `enableTableShareAndPersistence`, a table with the same name already exists in the persistence directory, and the table schema does not match that specified in the function.

## Solutions {#solutions .section}

1.  For the first case, check and modify the schema of data to be appended.
2.  For the second case, check and modify the schema of *table*specified in `enableTableShareAndPersistence`, or clean up the persisted files before enabling persistence.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

