# S03002 {#s03002}

## Error Code {#error_code .section}

S03002

## Error Message {#error_message .section}

`Subscription to table <xxx> already exists on this node. Change an actionName or cancel the existing subscription first. RefId:S03002`

## Probable Causes {#probable_causes .section}

This error occurs upon repetitive subscription topics. Supposing there is a subscription named *a* to a table *b* on a certain node. When users create another subscription with the same name *a* to a table also named *b*, the aforementioned error is reported.

Specifically, when using the `subscribeTable` function, it returns a unique subscription topic consisting of the hostname, port, alias of the node where the stream table is located, stream table name, and the subscription task name.

## Solutions {#solutions .section}

-   Choose another name for the stream table.

-   Change the *actionName* parameter in `subscribeTable`.

-   Cancel the existing subscription with the same name.


**Note**: For high-availability subscriptions, the following warning message may be logged when the DolphinDB client initiates reconnection: `This dolphindb client has already subscribed to the table <xxx>. RefId:S03002`. It indicates that this client has subscribed to the table in other ways and no additional processing is required.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

