# S03000 {#s03000}

## Error Code {#error_code .section}

S03000

## Error Message {#error_message .section}

`To undefine the shared stream table 'xxx', first cancel all subscriptions to it. RefId: S03000`

## Probable Causes {#probable_causes .section}

A stream table can be subscribed using the `subscribeTable` function in the following ways:

-   by the node where the table is located.

-   by another node.

-   by an API client.


These subscriptions will prevent the stream table from being undefined or destroyed. Only when all subscriptions to the table are canceled, can it be undefined with the `undef` function.

## Solutions {#solutions .section}

Call the `getStreamingStat` function to monitor the subscriptions to the stream table:

-   Check the subscriptions to the table with `getStreamingStat().pubTables`.

-   Check the connections between the publisher and all subscribers with `getStreamingStat().pubConns`.


Then, use the `unsubscribeTable` function to cancel the subscription. Once all subscriptions are canceled, the stream table can be undefined.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

