# S02056 {#S02056}

## Error Code {#error_code .section}

S02056

## Error Message {#error_message .section}

`For a distributed query, the TOP or LIMIT clause cannot specify an offset when used with GROUP BY clause. RefId: S02056`

## Probable Causes {#probable_causes .section}

This error occurs when the `top` or `limit` clause specifies an offset when used with `group by` or `context by` clause in a DFS query. For example:

``` {#codeblock_ucy_wtl_jcc}
dbName = "dfs://test"
if (existsDatabase(dbName)) {
    dropDatabase(dbName)
}
t = table(1..3 as id)
db = database(dbName, VALUE, 1..3)
pt = db.createPartitionedTable(t, `pt, `id)
pt.append!(t)

select id from pt group by id limit 1,1 => For a distributed query, the TOP or LIMIT clause cannot specify an offset when used with GROUP BY clause.
select id from pt context by id limit 1,1 => The TOP or LIMIT clause cannot specify an offset when used with CONTEXT BY clause. 
```

## Solutions {#solutions .section}

Modify the query to separate the `top` or `limit` clause from the `group by` or `context by` clause. Take the above-mentioned script as an example, first access the "id" column in a temporary in-memory table, and then specify the offset with the `limit` clause.

``` {#codeblock_omd_4wl_jcc}
tmp = select id from pt group by id limit 2
select * from tmp limit 1,1
```

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

