# S02053 {#S02053}

## Error Code {#error_code .section}

S02053

## Error Message {#error_message .section}

`The select clause with DISTINCT keyword must contain all ORDER BY columns. RefId: S02053`

## Probable Causes {#probable_causes .section}

This error occurs when the select statement with the keyword `distinct` does not contain all columns in the `order by` clause. For example:

``` {#codeblock_ucy_wtl_jcc}
def createMyTable(n) {
    intv = take(1..10, n)
    symbol = take(`a`b`c, n)
    id = rand(100, n)
    strv = take("abs" + string(1..10), n)
    doublev = rand(10.0, n)
    return table(intv, strv, doublev, id, symbol)
}

n = 100
t = createMyTable(n)

select DISTINCT id from t order by intv => The select clause with DISTINCT keyword must contain all ORDER BY columns.
```

## Solutions {#solutions .section}

Add all columns from the `order by` clause to the select statement with the keyword `distinct`.

``` {#codeblock_omd_4wl_jcc}
select DISTINCT intv, id from t order by intv
```

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

