# S02051 {#S02051}

## Error Code {#error_code .section}

S02051

## Error Message {#error_message .section}

`Row reduction operation <xxx> cannot be used with PIVOT BY clause within an EXEC statement. RefId: S02051`

## Probable Causes {#probable_causes .section}

When used with `pivot by`, the`exec` statement generates a matrix. This error occurs when applying [row-based functions](../../Functions/Themes/rowFunctions.md) to the returned matrix. For example:

``` {#codeblock_ucy_wtl_jcc}
def createMyTable(n) {
    intv = take(1..10, n)
    symbol = take(`a`b`c, n)
    id = rand(100, n)
    strv = take("abs" + string(1..10), n)
    doublev = rand(10.0, n)
    return table(intv, strv, doublev, id, symbol)
}

n = 100
t = createMyTable(n)

EXEC rowSum(doublev) FROM t PIVOT BY id, symbol => Row reduction operation "rowSum" cannot be used with PIVOT BY clause within an EXEC statement.
```

## Solutions {#solutions .section}

Replace the `exec` statement with the following select statement, which returns a table. The returned table can be converted to a matrix if needed.

``` {#codeblock_omd_4wl_jcc}
SELECT rowSum(doublev) FROM t PIVOT BY id, symbol
```

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

