# S02050 {#S02050}

## Error Code {#error_code .section}

S02050

## Error Message {#error_message .section}

`The "select" clause does not support the following functions: aggregate, order-sensitive, row reduction, and null-filling functions. RefId: S02050`

## Probable Causes {#probable_causes .section}

In a `pivot by` query, this error occurs when the following functions are applied to the query column:

-   Aggregate functions
-   Order-sensitive functions \(e.g. `rowSum`\)
-   Row-based functions \(e.g. `rowSum`\)
-   Null-filling functions \(e.g. `ffill`\)

``` {#codeblock_ucy_wtl_jcc}
time = [10:20:44,10:20:44,10:20:44,10:20:45,10:20:45,10:20:45,10:20:46,10:20:46,10:20:46,10:20:46,10:20:46,10:20:46]
sym = ["A","B","C","A","B","C","A","B","C","A","B","C"]
value = [510,434,999,837,402,615,495,885,745,968,975,165]
t = table(time,sym,value)

db = database("dfs://test_pivot",VALUE,`A`B`C)
pt = db.createPartitionedTable(t,`pt,`sym)
pt.append!(t)

select sum(asis(value)) from pt pivot by time,sym
select cumsum(asis(value)) from pt pivot by time,sym
select rowSum(asis(value)) from pt pivot by time,sym
select ffill(asis(value)) from pt pivot by time,sym
=> The 'select' clause does not support the following functions: aggregate, order-sensitive, row reduction, and null-filling functions.
```

## Solutions {#solutions .section}

Ensure that the afore-mentioned functions are not applied to the query column in a `pivot by` query.

Additionally, the conditions for the combined use of `asis` and `pivot by` specified in [pivot by](../../Programming/SQLStatements/pivotBy.md) should also be met.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

