# S02049 {#S02049}

## Error Code {#error_code .section}

S02049

## Error Message {#error_message .section}

`Analytic function does not support function '%s'. RefId: S02049`

## Probable Causes {#probable_causes .section}

[Analytic functions](../../Programming/SQLStatements/analytic_functions.md) specifies a series of supported functions. This error occurs when an unsupported function is used within an analytic function. For example:

``` {#codeblock_ucy_wtl_jcc}
id = `XOM`GS`AAPL
val = 102.1 33.4 73.6
date = 2020.01.01 2020.01.02 2020.01.01
t = table(id, val, date);

select database("123456", VALUE, 2024.02.01..2024.02.02) over () from t => Analytic function does not support function 'database'.
```

## Solutions {#solutions .section}

If the outcome of the unsupported function specified in the analytic function can be achieved by a [supported functions](../../Programming/SQLStatements/analytic_functions.md), replace it. Otherwise, use other SQL statements to achieve the outcome.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

