# S02046 {#S02046}

## Error Code {#error_code .section}

S02046

## Error Message {#error_message .section}

`Analytic functions are not allowed in WHERE clause, GROUP BY clause, or to be nested in aggregate functions. RefId: S02046`

## Probable Causes {#probable_causes .section}

This error occurs when an analytic function is applied in a `where` clause, `group by` clause, or nested in an aggregate function or user-defined function. For example:

``` {#codeblock_ucy_wtl_jcc}
id = `XOM`GS`AAPL
val = 102.1 33.4 73.6
date = 2020.01.01 2020.01.02 2020.01.01
t = table(id, val, date);

select id from t where max(val) over (partition by date rows 1 preceding) > 50
select id from t group by max(val) over (partition by date rows 1 preceding)
select min(max(val) over (partition by date rows 1 preceding)) from t
//Error: Analytic functions are not allowed in WHERE clause, GROUP BY clause, or to be nested in aggregate functions.
```

## Solutions {#solutions .section}

Restructure the query to separate the analytic function from the `where` clause, `group by` clause, aggregate function, or user-defined function.

``` {#codeblock_wgy_s5l_jcc}
select
    id
from
    t
where
    (
        exec
            max(val) over (partition by date rows 1 preceding)
        from
            t
    ) > 50
```

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

