# S02043 {#S02043}

## Error Code {#error_code .section}

S02043

## Error Message {#error_message .section}

`The 'asis' keyword is not supported without a PIVOT BY clause. Please include a valid PIVOT BY clause in your query. RefId:S02043`

## Probable Causes {#probable_causes .section}

If the SELECT clause uses the `asis` function, it must be used with the PIVOT BY clause, which is used to retain all duplicates.

For example, the error will occur when the `asis` function is used without a PIVOT BY clause.

``` {#codeblock_mbx_dpz_zbc}
sym = symbol(`C`IBM`C`IBM)
price= 49.6 10 29.46 29.52 
qty = 2200 100 1900 2100 
timestamp = [09:34:07,09:34:07,09:35:42,09:35:42]
t = table(timestamp, sym, qty, price)
dbName = "dfs://asisTest"
if(existsDatabase(dbName)){
	dropDatabase(dbName)
}
db=database(dbName, VALUE, distinct(sym),,`TSDB)
pt = createPartitionedTable(db, t, `pt,`sym,,`sym).append!(t)
select asis(price) from pt context by timestamp, sym
```

## Solutions {#solutions .section}

Make sure that the `asis` function is used with a PIVOT BY clause.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

