# S02032 {#S02032}

## Error Code {#error_code .section}

S02032

## Error Message {#error_message .section}

`Cannot nest aggregate function. RefId:S02032`

## Probable Causes {#probable_causes .section}

Nesting aggregate functions is not allowed in DolphinDB SQL.

For example, the `sum` function cannot be nested with another `sum` function.

``` {#codeblock_mbx_dpz_zbc}
item = table(1..10 as id, 10+rand(100,10) as qty)
select sum(sum(qty)) from item group by id
```

## Solutions {#solutions .section}

Most major databases, such as MySQL, PostgreSQL, SQLite, and ClickHouse, do not support nested aggregate functions. Please reconsider your query semantics.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

