# S02027 {#s02027}

## Error Code {#error_code .section}

S02027

## Error Message {#error_message .section}

`The length of the vector returned by the UDF specified in SELECT must be the same as the length of the CONTEXT BY column. RefId:S02027`

## Probable Causes {#probable_causes .section}

When using a UDF in a SELECT statement, the error may occur if the length of its return value does not match the length of CONTEXT BY column.

For example, the following query will throw an error for the `oneRow` function returns only one row.

``` {#codeblock_vsz_hx5_1bc}
n = 10000
id = take(1..10, n)
value = take(1..10, n)
t = table(id, value)

def oneRow(col) {
    return col[0:1]
}
select oneRow(value) from t context by id
```

## Solutions {#solutions .section}

Check the length of your UDF in the SELECT statement.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

