# S02023 {#s02023}

## Error Code {#error_code .section}

S02023

## Error Message {#error_message .section}

`The array vector specified in SELECT must be generated by function toArray. RefId:S02023`

## Probable Causes {#probable_causes .section}

In a query using GROUP BY clause, to SELECT an array vector that is converted from a column, the `toArray` function \(aggregate function\) must be used.

For example:

``` {#codeblock_bwg_sw5_1bc}
def fun(a) {
    return array(INT[],0,2).append!([1 2])
}

arr = 1..10
id = take(1..5,10)
t = table(arr, id)

select fun(arr) from t group by id;
```

## Solutions {#solutions .section}

Use `toArray` function in conjunction with the `group by` clause in a SQL query. The following query can be successfully executed:

``` {#codeblock_yh4_tw5_1bc}
select toArray(fun(arr)) from t group by id;
```

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

