# S02022 {#s02022}

## Error Code {#error_code .section}

S02022

## Error Message {#error_message .section}

`The column <xxx> must use aggregate function. RefId:S02022`

## Probable Causes {#probable_causes .section}

The GROUP BY clause can only be used with aggregate functions, which returns a single scalar value for each group.

For example, the following query will throw an error since `val + 1` produces two results within the "2020.01.01" group.

``` {#codeblock_qhs_nw5_1bc}
id = `XOM`GS`AAPL
val = 102.1 33.4 73.6
date = 2020.01.01 2020.01.02 2020.01.01
t = table(id, val, date);

select val + 1 from t group by date
```

## Solutions {#solutions .section}

Check whether the SELECT column use the aggregate function when using a GROUP BY clause. The following query can be successfully executed:

``` {#codeblock_bm1_pw5_1bc}
select val from t group by id
```

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

