# S02021 {#s02021}

## Error Code {#error_code .section}

S02021

## Error Message {#error_message .section}

`The HAVING clause after GROUP BY must be followed by a boolean expression. RefId:S02021`

## Probable Causes {#probable_causes .section}

This error occurs when the HAVING clause is not followed by a boolean expression.

For example:

``` {#codeblock_itx_2w5_1bc}
n = 10000
id = take(1..10, n)
value = take(1..10, n)
t = table(id, value)

a = 1.0
select max(value) from t group by id having a // throw an exception
select max(value) from t group by id having value // throw an exception
```

## Solutions {#solutions .section}

Ensure that the HAVING clause is followed by a boolean expression. The following query can be successfully executed:

``` {#codeblock_mnz_fw5_1bc}
select max(value) from t group by id having max(value) != 0
```

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

