# S02019 {#s02019}

## Error Code {#error_code .section}

S02019

## Error Message {#error_message .section}

`The column to be sorted cannot be an array vector. RefId:S02019`

## Probable Causes {#probable_causes .section}

The array vector column cannot be sorted. Therefore, this error occurs when using a CSORT clause on an array vector column.

For example, if the following query includes a CSORT clause on the "ask" column, which is an array vector, it will trigger the error:

``` {#codeblock_cbn_tv5_1bc}
bid = array(DOUBLE[], 0, 20).append!([1.4799 1.479 1.4787, 1.4796 1.479 1.4784, 1.4791 1.479 1.4784])
ask = array(DOUBLE[], 0, 20).append!([1.4821 1.4825 1.4828, 1.4818 1.482 1.4821, 1.4814 1.4818 1.482])
TradeDate = 2022.01.01 + 1..3
SecurityID = rand(`APPL`AMZN`IBM, 3)
t = table(SecurityID as `sid, TradeDate as `date, bid as `bid, ask as `ask)

select sum(bid) from t context by sid csort ask
```

## Solutions {#solutions .section}

Ensure that the sorted column is not an array vector.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

