# S02017 {#s02017}

## Error Code {#error_code .section}

S02017

## Error Message {#error_message .section}

`Invalid grouping column. RefId:S02017`

## Probable Causes {#probable_causes .section}

This error occurs when the number of rows in grouping column does not match the number of rows in the SELECT column.

For example, `oneRow(grp)` following the GROUP BY produces only one row, while the SELECT column "grp" holds two rows.

``` {#codeblock_yzm_nv5_1bc}
def oneRow(col){
    return col[0]
}
t = table([1,1] as grp)
select sum(grp)from t group by oneRow(grp)
```

## Solutions {#solutions .section}

Ensure that the grouping column is a vector that has the same size as the SELECT column.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

