# S02014 {#s02014}

## Error Code {#error_code .section}

S02014

## Error Message {#error_message .section}

`The right part of a join must be a table. RefId:S02014`

## Probable Causes {#probable_causes .section}

The *rightTable* parameter of table joiners \(e.g., `ej`, `lj`\) must be a table. This error occurs when a non-table object is passed as the *rightTable*.

For example, passing a vector "id" to `ej`.

``` {#codeblock_z5d_1v5_1bc}
login(`admin, `123456)
id = `XOM`GS`AAPL
x = 102.1 33.4 73.6
t = table(id, x);

select * from ej(t, id, `id)
```

## Solutions {#solutions .section}

Check the *rightTable* parameter for table joiners.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

