# S02013 {#s02013}

## Error Code {#error_code .section}

S02013

## Error Message {#error_message .section}

`The left part of a join must be a table. RefId:S02013`

## Probable Causes {#probable_causes .section}

The *leftTable* parameter of table joiners \(e.g., `ej`, `lj`\) must be a table. This error occurs when a non-table object is passed as the *leftTable*.

For example, passing a vector "id" to `ej`.

``` {#codeblock_mvw_v55_1bc}
login(`admin, `123456)
id = `XOM`GS`AAPL
x = 102.1 33.4 73.6
t = table(id, x);

select * from ej(id, t, `id)
```

## Solutions {#solutions .section}

Check the *leftTable* parameter for table joiners.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

