# S02008 {#s02008}

## Error Code {#error_code .section}

S02008

## Error Message {#error_message .section}

`Direct access using column names is not supported to retrieve data from a DFS table. Please use a SQL query instead. RefId:S02008`

## Probable Causes {#probable_causes .section}

DFS tables are stored across multiple data nodes. To ensure secure concurrent read and write operations, direct access to DFS tables using member variable is not allowed. This error occurs when attempting to access a DFS table using column names.

For example:

``` {#codeblock_jkj_ns5_1bc}
n = 10000
type = take(1..10, n)
t = table(type)
dbName = "dfs://test_db";
if (existsDatabase(dbName)) {
    dropDatabase(dbName)
}
db = database(dbName, HASH, [INT, 2])
pt = db.createPartitionedTable(t, `pt, `type)
pt.append!(t)

pt.type
```

## Solutions {#solutions .section}

Use a complete SQL statement to query a DFS table.

``` {#codeblock_ndl_4s5_1bc}
pt.type
==> select type from pt
```

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

