# S01067 {#S01067}

## Error Code {#error_code .section}

S01067

## Error Message {#error_message .section}

`The function specified in partitionColumns must return a vector/scalar when the input is a vector/scalar. RefId: S01067`

## Probable Causes {#probable_causes .section}

When applying a function to the partitioning column of a DFS partitioned table, the function must return a vector of the same length as the partitioning column. Otherwise, this error occurs.

For example:

``` {#codeblock_kt3_jvd_lcc}
def mypartitionFunc(val) {
	return sum(val)
}

dbName = "dfs://db1"
tb = table(1..3 as value, `a`b`c as sym)
if(existsDatabase(dbName)){
	dropDatabase(dbName)
}
db = database(dbName, VALUE, 2024.02.01..2024.02.02)
pt = db.createPartitionedTable(tb, `pt, "mypartitionFunc(value)")
//The function specified in partitionColumns must return a vector when the input is a vector.
```

## Solutions {#solutions .section}

Ensure that the function applied to the partitioning column returns a result with the same structure and length as the partitioning column.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

