# S01016 {#s01016}

## Error Code {#error_code .section}

S01016

## Error Message {#error_message .section}

`Some of the data being written is not defined in the partitioning scheme of the target database. RefId:S01016`

## Probable Causes {#probable_causes .section}

When writing data to a VALUE-partitioned database with the configuration parameter *newValuePartitionPolicy*set to 'fail', this error is reported if not all data belongs to the current partitioning scheme.

## Solutions {#solutions .section}

-   Set *newValuePartitionPolicy*to 'add' to automatically add new partitions.
-   Set *newValuePartitionPolicy* to 'skip' to skip data that does not belong to the existing partitions. The skipped data will be discarded.
-   Before writing data, use `addValuePartitions` to add corresponding partitions in advance.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

