# S01014 {#s01014}

## Error Code {#error_code .section}

S01014

## Error Message {#error_message .section}

`A column with name <xxx> already exists in table. RefId:S01014`

## Probable Causes {#probable_causes .section}

When using the `addColumn` function to add a column, this error is thrown if any of the *colNames*already exists in the table.

## Solutions {#solutions .section}

-   Use the `schema` function to check the table schema. For example, use the following script to get the columns of table *pt1*in the *dfs://testDB* database:

    ``` {#codeblock_xhl_w14_1bc}
    schema(loadTable("dfs://testDB","pt1")).colDefs
    ```

    |name|typeString|typeInt|extra|comment|
    |----|----------|-------|-----|-------|
    |id|INT|4|||
    |x|DOUBLE|16|||

-   When using `addColumn`, make sure the specified *colNames*not conflict with the existing columns in the target table. Note that column names in DolphinDB are case-insensitive.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

