# S01006 {#s01006}

## Error Code {#error_code .section}

S01006

## Error Message {#error_message .section}

`The chunk <chunkId> is reported as stale on the controller. Check the controller logs for further troubleshooting. RefId: S01006`

## Probable Causes {#probable_causes .section}

This log message may occur when a data node reports its partitioning information to the controller. During the reporting process, if the chunk is undergoing operations \(such as modification\), the chunk version may be updated, causing some of the reported partitioning information to become stale. The data node will then attempt to report again.

## Solutions {#solutions .section}

This error occurs infrequently and can self-recover. You can search for the partition information in the logs or execute the following SQL statement to check if the number of replicas for the partition is correct:

``` {#codeblock_wjz_lln_1bc}
select * from rpc(getControllerAlias, getClusterChunksStatus) where chunkId = "XXX"
```

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

