# S00016 {#S00016}

## Error Code {#error_code .section}

S00016

## Error Message {#error_message .section}

`Cannot recognize function: <xxx>. RefId: S00016`

## Probable Causes {#probable_causes .section}

The initial *depth* of a job is 0. *depth* is automatically incremented by 1 when the initial job generates a task or sends a job to another node. However, the maximum limit for *depth* is 6. This error occurs when the limit is exceeded.

Suppose there is a cluster containing two nodes, node1 and node2. This error occurs when executing the following script on node1:

``` {#codeblock_uvd_jtl_jcc}
def myRpc1() { return rpc("node2", peach, log, (1..3, 4..6))}
def myRpc2() { return rpc("node1", myRpc1) }
def myRpc3() { return rpc("node2", myRpc2) }
def myRpc4() { return rpc("node1", myRpc3) }
def myRpc5() { return rpc("node2", myRpc4) }
def myRpc6() { return rpc("node1", myRpc5) }
def myRpc7() { return rpc("node2", myRpc6) }

myRpc7()
// The task queue depth cannot exceed 6
```

## Solutions {#solutions .section}

Ensure not to exceed the *depth* limit of 6. After this error occurs, it is recommended not to use the `rpc` function to execute a local job on another node.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

