# S00015 {#S00015}

## Error Code {#error_code .section}

S00015

## Error Message {#error_message .section}

`Cannot recognize function: <xxx>. RefId: S00015`

## Probable Causes {#probable_causes .section}

This error occurs when the system attempts to retrieve the function definition using the corresponding function name on the current node during deserialization.

In the following example, the awss3 plugin is loaded on the current node but the function `aws::version` is called on another, thus triggering the error:

``` {#codeblock_pt5_dtl_jcc}
loadPlugin("awss3")
conn = xdb(host, port, "admin", "123456")
remoteRun(conn, aws::version)

//remoteRun(conn, aws::version) => Can't recognize function: aws::version
```

## Solutions {#solutions .section}

Ensure that the function called and its definition are on the same node.

**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

