# S00007 {#s00007}

## Error Code {#error_code .section}

S00007

## Error Message {#error_message .section}

`Closing connection with fd=xxx. Failed to parse the incoming connection with error xxx, error code xxx. Check your network connection. RefId:S00007`

## Probable Causes {#probable_causes .section}

After receiving a request from the client \(API or Web\), the server first parses the header information to obtain its command type \(e.g., HTTP, API, and STREAM\), sessionID, length, and attributes \(rootId, priority, concurrency, client ID, seqNo, etc.\). This error occurs if the parsing fails, which may be attributed to:

1.  Network errors such as network interruptions and peer disconnections.

2.  Protocol errors: The header information of the message does not adhere to the fixed protocol format.

3.  Message type errors: The type of the message is not supported by the current version of the server.


## Solutions {#solutions .section}

1.  Check the network connection.

2.  Check the API and server versions to see if the protocols are compatible.

3.  Check the protocol types used by the API to see if they are supported by the server.


## Details {#section_details .section}

``` {#codeblock_exn_tyn_1bc}
1  Socket is disconnected/closed or file is closed. 
2  In non-blocking socket mode, there is no data ready for retrieval yet. 
3  Out of memory, no disk space, or no buffer for sending data in non-blocking socket mode. 
4  String size exceeds 64K or code size exceeds 1 MB during serialization over network. 
5  In non-blocking socket mode, a program is in pending connection mode. 
6  Invalid message format. 
7  Reach the end of a file or a buffer. 
8  File is readable but not writable. 
9  File is writable but not readable. 
10 A file doesn't exist or the socket destination is not reachable. 
11 The database file is corrupted. 
12 Not the leader node of the RAFT protocol. 
13 Unknown IO error.
```

These are standard error codes of the operating system. For more information, see:

-   Linux :

    -   [strerror\(3\) - Linux manual page \(man7.org\)](https://www.man7.org/linux/man-pages/man3/strerror.3.html)

    -   [errno\(3\) - Linux manual page \(man7.org\)](https://www.man7.org/linux/man-pages/man3/errno.3.html)

-   Windows:

    -   [FormatMessage function \(winbase.h\) - Win32 apps \| Microsoft Learn](https://learn.microsoft.com/en-us/windows/win32/api/winbase/nf-winbase-formatmessage)

    -   [WSAGetLastError function \(winsock.h\) - Win32 apps \| Microsoft Learn](https://learn.microsoft.com/en-us/windows/win32/api/winsock/nf-winsock-wsagetlasterror)


**Parent topic:**[Error Code Reference](../../Troubleshooting/ErrorCode.md)

