# DolphinDB hex2Base64 插件使用说明

Hex 字符串编码为 Base64 编码的插件，需求详见 https://dolphindb1.atlassian.net/browse/PRAS-1275。

## 函数接口

### encode

**语法**

``` Dolphin Script
hex2Base64::encode(X)
```

**参数**

**X** 字符串类型的标量

**详情**

将 16 进制字符串转换为字节数组，然后将字节数组转换为 Base64 字符串。

**示例**
``` Dolphin Script
hex2Base64::encode("e1e8882db5a30b7988e60d0326236153a0145ea1e8ab2955397393466b34c768")
// '4eiILbWjC3mI5g0DJiNhU6AUXqHoqylVOXOTRms0x2g='
```

## 编译构建

### Linux 编译构建

将源码放在 DolphinDBPlugin 项目的根目录，然后在源码根目录执行如下命令，即可在 output 文件夹下生成插件的 so 和 txt 文件。

```bash
export CMAKE_INSTALL_PREFIX="$(pwd)/output/$PluginName"
# 默认 ABI1
export CXXFLAGS="-D_GLIBCXX_USE_CXX11_ABI=0" # 通过环境变量指定编译 ABI0
CXX=g++-8 CC=gcc-8  bash -x ./build.sh # 按需修改编译器版本
```
