#pragma once

#include "CoreConcept.h"
#include "DDBPlugin.h"

const string PLUGIN_NAME = "Backtest";

class BacktestWrapper : public DDBPlugin {
    ConstantSP engine_;
    ConstantSP name_;
    DictionarySP config_;
    DictionarySP eventCallbacks_;
    ConstantSP jit_;
    TableSP securityReference_;

  public:
    BacktestWrapper(ConstantSP name, DictionarySP config, DictionarySP eventCallbacks, ConstantSP jit,
                    TableSP securityReference);
    BacktestWrapper(ConstantSP name);
    static SmartPointer<BacktestWrapper> createBacktester(ConstantSP name, DictionarySP config,
                                                          DictionarySP eventCallbacks, ConstantSP jit,
                                                          TableSP securityReference);
    ConstantSP appendQuotationMsg(TableSP msg);
    static ConstantSP appendQuotationMsg(ConstantSP engine, TableSP msg);
    ConstantSP setUniverse(VectorSP symbolList);
    static ConstantSP setUniverse(ConstantSP engine, VectorSP symbolList);
    ConstantSP submitOrder(ConstantSP msg, ConstantSP label, ConstantSP orderType, ConstantSP accountType);
    static ConstantSP submitOrder(ConstantSP engine, ConstantSP msg, ConstantSP label, ConstantSP orderType,
                                  ConstantSP accountType);
    ConstantSP getPosition(ConstantSP symbol, ConstantSP accountType);
    static ConstantSP getPosition(ConstantSP engine, ConstantSP symbol, ConstantSP accountType);
    ConstantSP getDailyPosition(ConstantSP symbol, ConstantSP accountType);
    static ConstantSP getDailyPosition(ConstantSP engine, ConstantSP symbol, ConstantSP accountType);
    ConstantSP getTradeDetails();
    static ConstantSP getTradeDetails(ConstantSP engine);
    ConstantSP cancelOrder(ConstantSP symbol);
    static ConstantSP cancelOrder(ConstantSP engine, ConstantSP symbol);
    ConstantSP getOpenOrders(ConstantSP symbol, ConstantSP orders, ConstantSP label, ConstantSP accountType);
    static ConstantSP getOpenOrders(ConstantSP engine, ConstantSP symbol, ConstantSP orders, ConstantSP label, ConstantSP accountType);
    void dropBacktestEngine();
};