from binance.websocket.um_futures.websocket_client import UMFuturesWebsocketClient
import time
from ..configs import BINANCE_BASE_CONFIG
def message_handler(_, message):
    print(f"Receive message: {message}")

client = UMFuturesWebsocketClient(
    on_message=message_handler,
    proxies={'http': 'http://127.0.0.1:7890'}
)

client.continuous_kline(pair="btcusdt", contractType="perpetual", interval="1m")
print("Waiting for data...")
time.sleep(120)  # Wait for 2 minutes (at least until one OHLC bar closes).
print("client closed")
client.stop()