from Binance_framework import BinanceBaseConfig, IOThread, normalize_row
from binance.websocket.um_futures.websocket_client import UMFuturesWebsocketClient
import time, json, numpy as np
class BinanceContractInfoConfig(BinanceBaseConfig):

    TIMEOUT = 3600
    """Binance contractInfo data ingestion config"""
    tableName = "Cryptocurrency_contractInfoST"
    BUFFER_FILE = "./Binance_contractInfo_fail_buffer.jsonl"
    
    
    def get_create_table_script(self) -> str:
        return '''
// Low-frequency data - contractInfo 
dbName = "dfs://CryptocurrencyDay"
tbName = "contractInfo"
streamtbName = "Cryptocurrency_contractInfoST"
colNames = 
`eventTime`collectionTime`symbolSource`symbol`contractType`contractDirection`deliveryDatetime`onboardDatetime`contractStatus`notionalBracket`floorNotional`capNotional`maintenanceRatio`auxiliaryNumber`minLeverage`maxLeverage`settleCurrency`tickSize`lotSize`minSize`contractValue`contractMultiplier`contractValueCurrency
colTypes = [TIMESTAMP, TIMESTAMP, SYMBOL, SYMBOL,STRING,STRING,TIMESTAMP, TIMESTAMP, STRING, INT, DOUBLE, DOUBLE, DOUBLE, DOUBLE, DOUBLE, DOUBLE, STRING, DOUBLE, DOUBLE, DOUBLE, DOUBLE,  DOUBLE, STRING]  

if(!existsDatabase(dbName)){
    db = database(dbName,RANGE,2010.01M+(0..20)*60)
}else{ db=database(dbName)}
if(!existsTable(dbName,tbName)){
    createPartitionedTable(db,table(1:0,colNames,colTypes),tbName,`eventTime) 
}
enableTableShareAndPersistence(table=keyedStreamTable(`symbolSource`symbol`eventTime, 10000:0, colNames, colTypes), tableName=streamtbName, cacheSize=100000, retentionMinutes=2880)
go
contractInfoTb = loadTable(dbName, tbName)
subscribeTable(tableName=streamtbName, actionName="insertDB", offset=-2, handler=contractInfoTb, msgAsTable=true, batchSize=10000, throttle=1, persistOffset=true)
        '''
    
    def create_message_handler(self):
        def message_handler(_, message):
            self.last_received_time = time.time()
            j = json.loads(message)
            if j.get("e") != "contractInfo":
                return            
            base_cols = [
                j['E'] ,
                int(time.time()*1000) ,
                "Binance-Futures",
                j['s'],j["ct"],"linear",j["dt"],j["ot"],j["cs"],

            ]
            end_cols = [None,None,None,None,None,None,None]
            bks = j.get("bks") or []
            
            if bks:
                for bk in bks:
                    notional_bracket = int(bk.get("bs", 0))      # bracket index
                    floor_notional   = float(str(bk.get("bnf", 0))) # notional lower bound
                    cap_notional     = float(str(bk.get("bnc", 0)))  # notional upper bound
                    maintenance_ratio= float(str(bk.get("mmr", 0)))  # maintenance margin ratio
                    auxiliary_number = float(str(bk.get("cf", 0)))  # rule-of-thumb constant
                    min_leverage     = float(bk.get("mi", 0))      # minimum leverage
                    max_leverage     = float(bk.get("ma", 0))      # maximum leverage

                    cols = base_cols + [
                        notional_bracket, floor_notional, cap_notional,
                        maintenance_ratio, auxiliary_number, min_leverage, max_leverage
                    ] + end_cols
                    try:                      
                        self.realtime_q.put(cols, block=False)
                    except:
                        # Fallback handling
                        with self.file_lock, open(self.BUFFER_FILE, "a", encoding="utf-8") as f:
                            f.write(json.dumps(self.normalize_row(cols), ensure_ascii=False) + "\n")  
            else:
                cols = base_cols + [None, None, None, None, None, None, None] + end_cols       
                try:
                    self.realtime_q.put(cols, block=False)
                except:
                    # Fallback handling
                    with self.file_lock, open(self.BUFFER_FILE, "a", encoding="utf-8") as f:
                        f.write(json.dumps(self.normalize_row(cols), ensure_ascii=False) + "\n")
        
        return message_handler
    
    def start_client_and_subscribe(self):
        client = UMFuturesWebsocketClient(
            on_message=self.create_message_handler(),
            proxies={'http': self.proxy_address, 'https': self.proxy_address}
        )
        
        client.subscribe(stream="!contractInfo")
             
        return client


if __name__ == "__main__":
    config = BinanceContractInfoConfig()
    client = config.start_all()
    
    # Keep the main thread running
    try:
        while True:
            time.sleep(1)
    except KeyboardInterrupt:
        config.quick_exit()